/*
*******************************************************************************
*
* File:         dyndefs.h
* Description:  
* Author:       Henrik Liebau
* Created:      Dec 3, 1997
* Modified:     Tue Oct 27 10:46:46 1998 (Henrik Liebau) Henrik_Liebau@HP.com
* Language:     C
* Package:      N/A
* Status:       Experimental (Do Not Distribute)
*
* (C) Copyright 1997, 1998, Hewlett-Packard GmbH, all rights reserved.
*
*******************************************************************************
*/

#ifndef DYNDEFS_H_INCLUDED
#define DYNDEFS_H_INCLUDED


/* ---------------------------------------------------------------
 * Type Definitions for paramter types and paraminfotypes
 * This is used for the dynamic capabilities lists. The lists and
 * functions return data structures of the following types.
 * License Information is also kept  here. Depending on the license
 * the user has different parameters can get chosen or not. This is
 * encoded in the paramter information.
 * --------------------------------------------------------------- */


/* B_PARAM_CUSTOM
   This group is not supported by dynamic capabilities. However, it refers
   to the enum type b_paramcustom in berror.h where you can define additional
   parameters to take advantage of the range checking return values.
   CZ
*/

typedef enum { /* used to distinguish what kind of parameter/signal is stored*/
  B_PARAM_CUSTOM = 0,	      /* has to be zero!!, CZ */
  
  B_PARAM_MASTER_BLOCK,       /* has generic and param info */
  B_PARAM_MASTER_ATTR,        /* has generic and param info */
  B_PARAM_MASTER_GEN,         /* has generic and param info */
  B_PARAM_DECODER_GEN,	      /* generic info about all decoders */
  B_PARAM_DECODER_STD,        /* has generic and param info standard decoder */
  B_PARAM_DECODER_EXP,        /* has generic and param info expansion rom dec*/
  B_PARAM_DECODER_CFG0,       /* has generic and param info config type 0 dec*/
  B_PARAM_DECODER_CFG,        /* has generic and param info config decoder   */
  B_PARAM_DECODER_SUB,        /* has generic and param info subtractive decod*/
  B_PARAM_DECODER_UCFG,       /* has generic and param info user config decod*/
  B_PARAM_TARGET_ATTR,        /* has generic and param info */
  B_PARAM_TARGET_GEN,         /* has generic and param info */
  B_PARAM_DATA_MEM,           /* has generic info only */
  B_PARAM_TRACE_GEN,          /* generic trace props, generic and param info */
  B_PARAM_TRACE_MEM,          /* has generic and param info */
  B_PARAM_PATTERN,            /* has generic and param info */
  B_PARAM_TRIGSEQ,            /* generic and param, mixed properties !! */
  B_PARAM_PERFSEQ,            /* generic and param, mixed properties !! */
  B_PARAM_OBSRULES,           /* generic and param, only strings  */
  B_PARAM_OBSSTATUS,          /* holds the oberserver status properties    */
  B_PARAM_TCSIG,              /* generic and param, only strings  */
  B_PARAM_TCSTATUS,           /* holds the timing checker status properties  */
  B_PARAM_TCPROP,             /* holds the timing checker properties    */
  B_PARAM_TCGENPROP,          /* holds the timing checker generic properties */
  B_PARAM_MAGROUPINFO,        /* group information (only strings)            */
  B_PARAM_TAGROUPINFO,        /* group information (only strings)            */
  B_PARAM_BOARD,	      /* board properties                            */
  B_PARAM_PUINFO,	      /* power up properties                         */
  B_PARAM_EXERCISER_GEN,      /* has generic and param info                  */
  B_PARAM_CPUPORT,            /* param info only                             */
  B_PARAM_STATICIO,           /* param info only                             */
  B_PARAM_SSTCFG,	      /* SST config properties                       */
  B_PARAM_SSTPROP,	      /* SST properties                              */
  
  B_PARAM_CPCI_PIN,	      /* pin info for Compact PCI                    */
  B_PARAM_CPCI_STATUS,	      /* status info for Compact PCI                 */

  B_PARAM_LAST		      /* for range checking only                     */
} b_paramtype;


typedef enum {
   par_req,
   par_opt,
   par_def,
   par_no
} b_syntaxParamType;

typedef enum {
  attr_grp_nogrp,
  attr_grp_addr,
  attr_grp_data,
  attr_grp_ctrl,
  attr_grp_last
} b_attr_grptype;

/* the following enum is especially interesting for the target decode window,
   but other applications may also be possible:
   the target decoder properties are categorized into four groups:
    - view props: View-Only, may be shown but never changed
    - hard props: May be changed, but only as power-up defaults
    - soft props: May be changed even in a running system
    - other     : Not shown, (e.g. properties that are ignored anyway for
                              normal behavior)
*/
typedef enum {
  DEC_PROP_VIEW,
  DEC_PROP_HARD,
  DEC_PROP_SOFT,
  DEC_PROP_OTHER
} b_deccategorytype;



#ifndef BEST_FIRMWARE

#include <bddefs.h>
#include <cpupdefs.h>
#include <ladefs.h>
#include <latrdefs.h>
#include <masdefs.h>
#include <obsdefs.h>
#include <perfdefs.h>
#include <propdefs.h>
#include <sstdefs.h>
#include <tardefs.h>
#include <tdecdefs.h>
#include <tichdefs.h>
#include <trcdefs.h>
#include <triodefs.h>
#include <compdefs.h>

/* some of the parameters must follow special rules (must be dividable by
 * four (dword boundary) or dividable by 128 ... whatever)
 * these defines remember these special cases */
#define B_PARAMRULE_NORULE	 0x00
#define B_PARAMRULE_DWORDBOUND   0x01
#define B_PARAMRULE_128BOUND     0x02
#define B_PARAMRULE_EVEN         0x04
#define B_PARAMRULE_MINMAXONLY   0x08
/* numbers 0x10 to 0x40 are used by pattern term definitions */

/* this one allows a range between x and y as well as a value of 0  *
 * for range checking                                               */
#define B_PARAMRULE_ZEROALLOWED    0x80


#define B_PARAMRULE_MAXLONGALLOWED 0x100

/*
For timing checker signals:
Minimum value for mask is zero and maximum is (2^width)-1
Remark: signal width is stored in max_val (see e2926a_tc_signal_table[]) */
#define B_PARAMRULE_ZERO2WIDTH  0x200


/* Allows set of values (range [minval+0,..,minval+31] with holes)
   Each set Bit represents an allowed value */
#define B_PARAMRULE_BITSET 0x400

typedef union {
  b_paramtype		      param;          /* param for more  dyncap info */
  b_blkproptype               blockprop;      /* master block properties     */
  b_mattrproptype             mattrprop;      /* master attribute properties */
  b_tattrproptype             tattrprop;      /* target attribute properties */
  b_mattrgrouptype	      mattrgroupprop; /* master attr group props     */
  b_tattrgrouptype	      tattrgroupprop; /* target attr group props     */
  b_decodertype		      decoder;        /* decoder                     */
  b_decproptype               decprop;        /* decoder properties          */
  b_deccategorytype	      deccategory;    /* decoder prop categories     */
  b_mastergenproptype         mgenprop;       /* master generic properties   */
  b_exercisergenproptype      egenprop;       /* exerciser generic properties*/
  b_targetgenproptype         tgenprop;       /* target generic properties   */
  b_traceproptype             traceprop;      /* generic trace properties    */
  b_signaltype                signalprop;     /* signals                     */
  b_trigseqgenproptype        trigseqgenprop; /* TriggerSequencer generic P. */
  b_trigseqtranproptype       trigseqparprop; /* TriggerSeq. transition Prop */
  b_trigseqtrancondproptype   trigseqconprop; /* TriggerSeq. condition Props */
  b_perfgenproptype           perfseqgenprop; /* Perf. Seq. generic Props    */
  b_perfseqtranproptype       perfseqparprop; /* Perf. Seq. transition Props */
  b_perfseqtrancondproptype   perfseqconprop; /* Perf. Seq. condition Props  */
  b_obsruletype               obsrule;        /* the Observer Rule           */
  b_obsstatustype             obsstatus;      /* the Observer Status type    */
  b_tcproptype                tcprop;         /* Timing Checker props        */
  b_cpuproptype               cpuprop;        /* CPU port properties         */
  b_staticproptype            staticprop;     /* Static IO Properties        */
  b_attr_grptype	      attr_grp;	      /* Group type (data/addr/last) */
  b_boardproptype             boardprop;      /* generic board properties    */
  b_sstcfgproptype	      sstcfgprop;     /* SST config properties       */
  b_sstproptype		      sstprop;	      /* SST properties              */
  b_cpcipintype		      cpcipin;        /* compact PCI pin             */
  b_cpcistatustype	      cpcistatus;     /* compact PCI hotswap status  */
  b_int32                     value;          /* needed for the cast         */
} b_paramproptype;


typedef struct {
  b_charptrtype  param_name;           /* namestring of standard form        */
  b_charptrtype  param_short;          /* namestring of the short form       */
  b_int32        min_val;              /* minimum value also bitstart(signal)*/
  b_int32        max_val;              /* maximum value also width (signal)  */
  b_int32        defaultval;           /* default value of this parameter    */
  b_charptrtype  defaultstr;           /* some params require strings (equat)*/
  b_int32        paramrule;            /* param might have a special rule    */
  b_paramproptype  proptyp;            /* property for the C-API call (union)*/
  const b_param_stringlisttype * stringlist; /* array of possible stringlists */
  b_syntaxParamType syntaxinfo[6];     /* compiler syntax information        */
  b_paramproptype  grouploop;          /* group information for properties   */
} b_param_infotype;


typedef struct {
  b_charptrtype  group_name;           /* the name of the group (error need) */
  b_int32        depth;                /* depth of block/attr/memory/ etc    */
  size_t         num_elem;             /* number of decoder/signals etc      */
  b_int32        num_pages;            /* number of pages (needed sometimes) */
  b_int32        num_blocks;           /* blocks_per_page*num_pages */
  b_int32        blocks_per_page;      /* size of a page */
  b_int32        int_mem_offset;       /* where to start in internal memory  */
  b_int32	 fixeddelay; 	       /* delay between blocks in usec       */
} b_generic_infotype;


/* NOTE:
   typedef is done in typedefs.h (forward use of this type), CZ */

struct b_dynamic_cap_type {
  b_int32* capa_code;/* holds license information and the license key     */

  /* master block generic and specific (for all params) information          */
  b_generic_infotype *masterblock_gen;
  b_param_infotype  *masterblock_param;

  /* master attribute generic and specific (for all params) information      */
  b_generic_infotype *masterattr_gen;
  b_param_infotype  *masterattr_param;

  /* master generic properties generic and specific information              */
  b_generic_infotype *mastergen_gen;
  b_param_infotype  *mastergen_param;

  /* master generic properties generic and specific information              */
  b_generic_infotype *exercisergen_gen;
  b_param_infotype   *exercisergen_param;

  /* target attribute generic and specific (for all params) information      */
  b_generic_infotype *targetattr_gen;
  b_param_infotype  *targetattr_param;

  /* target generic attribute generic and specific  information              */
  b_generic_infotype *targetgen_gen;
  b_param_infotype  *targetgen_param;

  /*-------------------- Decoder generic/param info ----------------------*/
  /* information about all decoders */
  b_generic_infotype *decoder_gen;
  b_param_infotype  *decoder_param;
  /* information about standard target decode */
  b_generic_infotype *decoder_std_gen;
  b_param_infotype  *decoder_std_param;
  /* information about expansion rom target decode */
  b_generic_infotype *decoder_exp_gen;
  b_param_infotype  *decoder_exp_param;
  /* information about config 0 type  target decode */
  b_generic_infotype *decoder_cfg0_gen;
  b_param_infotype  *decoder_cfg0_param;
  /* information about config target decode */
  b_generic_infotype *decoder_cfg_gen;
  b_param_infotype  *decoder_cfg_param;
  /* information about subtractive target decode */
  b_generic_infotype *decoder_sub_gen;
  b_param_infotype  *decoder_sub_param;
  /* information about user config target decode */
  b_generic_infotype *decoder_ucfg_gen;
  b_param_infotype  *decoder_ucfg_param;
  
  /* information about data memory (generic only)                            */
  b_generic_infotype *datamemory_gen;

  /* information about generic trace properties (generic and specific)       */
  b_generic_infotype *tracegen_gen;
  b_param_infotype  *tracegen_param;

  /* information about trace memory (generic and specific)                   */
  b_generic_infotype *tracemem_gen;
  b_param_infotype  *tracemem_param;

  /* information about standard pattern terms (generic and specific)         */
  b_generic_infotype *pattern_gen;
  b_param_infotype  *pattern_param;

  /* trigger sequencer generic info      (generic and specific)              */
  b_generic_infotype *seqtriggergen_gen;
  b_param_infotype  *seqtriggergen_param;

  /* trigger sequencer parameter info (generic and specific)                 */
  b_generic_infotype *seqtriggerpar_gen;
  b_param_infotype  *seqtriggerpar_param;

  /* performance sequencer generic info (generic and specific)               */
  b_generic_infotype *seqperforgen_gen;
  b_param_infotype  *seqperforgen_param;

  /* performance sequencer parameter info (generic and specific)             */
  b_generic_infotype *seqperforpar_gen;
  b_param_infotype  *seqperforpar_param;

  /* observer rules parameter info (generic and specific)                    */
  b_generic_infotype *observerrules_gen;
  b_param_infotype  *observerrules_param;

  /* observer status parameter info (generic and specific)                   */
  b_generic_infotype *observerstatus_gen;
  b_param_infotype  *observerstatus_param;

  /* timing checker parameter info (generic and specific)                    */
  b_generic_infotype *timchecksig_gen;
  b_param_infotype  *timchecksig_param;

  /* Timing Checker status parameter info (generic and specific)                   */
  b_generic_infotype *timcheckstatus_gen;
  b_param_infotype  *timcheckstatus_param;

  /* Timing Checker prop parameter info (generic and specific)                   */
  b_generic_infotype *timcheckprop_gen;
  b_param_infotype  *timcheckprop_param;

  /* Timing Checker genprop parameter info (generic and specific)                   */
  b_generic_infotype *timcheckgenprop_gen;
  b_param_infotype  *timcheckgenprop_param;

  /* master attr group information (strings only)                    */
  b_generic_infotype *mattrgroupinfo_gen;
  b_param_infotype  *mattrgroupinfo_param;

  /* target attr group information (strings only)                    */
  b_generic_infotype *tattrgroupinfo_gen;
  b_param_infotype  *tattrgroupinfo_param;

  /* cpu port  interface group information */
  b_generic_infotype *cpuport_gen;
  b_param_infotype   *cpuport_param;

  /* static io  interface group information */
  b_generic_infotype *staticio_gen;
  b_param_infotype   *staticio_param;

  /* power up properties */
  b_generic_infotype	*pu_gen;
  b_param_infotype	*pu_param;

  /* s.f. board properties */ 
  b_generic_infotype	*board_gen;
  b_param_infotype	*board_param;
  
  /* s.f. SST properties */ 
  b_generic_infotype	*sstcfg_gen;
  b_param_infotype	*sstcfg_param;
  b_generic_infotype	*sst_gen;
  b_param_infotype	*sst_param;

  /* Compact PCI specials */
  b_generic_infotype    *cpcipin_gen;
  b_param_infotype      *cpcipin_param;
  b_generic_infotype    *cpcistatus_gen;
  b_param_infotype      *cpcistatus_param;
};


#endif /* if not BEST_FIRMWARE */

#endif
